/* 
 *  GetConsultDestinationsRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.api.InteractionI;
import com.avaya.ccs.api.enums.ContactType;
import com.avaya.ccs.api.enums.DestinationType;

import java.util.ArrayList;
import java.util.List;

public class GetConsultDestinationsRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(GetConsultDestinationsRequest.class);

    public GetConsultDestinationsRequest(String interactionID) {
        super(LOG, interactionID);
    }

    List<DestinationType>  types= new ArrayList<DestinationType>();
    
    /**
     * The call method executes on the outgoingRequest thread
     * The response (caught in Session.java) maps to a DestinationList object
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.info(methodName + "+");
        InteractionI interaction = getInteraction();

//        List<DestinationType> types = interaction.getConsultDestinationTypes();

        LOG.info("call()" + "interaction: " + interaction.getId());
        
        types.add(DestinationType.Agent);
        if (interaction.getContactType() == ContactType.POM_Outbound) {
            types.add(DestinationType.External);
        }
        else {
            types.add(DestinationType.Skillset);
        }
     
        for (DestinationType type : types) {
            LOG.info(methodName, " requesting type:" + type.name());
            interaction.getConsultDestinations(type);
        }

        LOG.info(methodName + "-");
        return null;
    }
}
